import React, { useEffect, useState } from 'react'
import ReactDOM from 'react-dom'

function App() {
  const [width, setWidth] = useState(window.innerWidth)
  const [counter, setCounter] = useState(0)

  function onResize(event) {
    setWidth(event.target.innerWidth)
  }

  useEffect(() => {
    console.count('useEffect: addEventListener')

    if (width > 500) {
      // Do something with this variable. The point is to demonstrate that this causes the cleanup function to be called
    }

    window.addEventListener('resize', onResize)

    return () => {
      console.count('useEffect: removeEventListener')

      window.removeEventListener('resize', onResize)
    }
  }, [width])

  useEffect(() => {
    console.count('useEffect: addEventListener2')

    if (width > 500) {
      // Do something with this variable. The point is to demonstrate that this causes the cleanup function to be called
    }

    window.addEventListener('resize', onResize)

    return () => {
      console.count('useEffect: removeEventListener2')

      window.removeEventListener('resize', onResize)
    }
  }, [width])

  console.count('render')

  return (
    <>
      <p>
        Hinweis: Browser-Fenster verkleinern/vergrößern um Veränderungen in der
        Breite zu sehen. Über den Button kann ein Neurendern erzwungen werden
      </p>

      <button onClick={() => setCounter(counter + 1)}>
        Neurendern erzwingen
      </button>

      <h1>Breite: {width} Pixel</h1>
    </>
  )
}

ReactDOM.render(<App />, document.getElementById('root'))
